package com.begumyolcu.devbytes_starter.util

private val PUNCTUATION = listOf(", ", "; ", ": ", " ")

/**
 * Uzun metni, sözcük sınırlarını tercih ederek ve noktalama işaretleri olmadan kısaltın.
 */
fun String.smartTruncate(length: Int): String {
    val words = split(" ")
    var added = 0
    var hasMore = false
    val builder = StringBuilder()
    for (word in words) {
        if (builder.length > length) {
            hasMore = true
            break
        }
        builder.append(word)
        builder.append(" ")
        added += 1
    }

    PUNCTUATION.map {
        if (builder.endsWith(it)) {
            builder.replace(builder.length - it.length, builder.length, "")
        }
    }

    if (hasMore) {
        builder.append("...")
    }
    return builder.toString()
}